/***********************************************************************************************\
* Freescale FXOS8700CQ Driver
*
* Filename: FXOS8700CQ.h
*
* Description: Driver header file for Freescale MMA851Q, MMA8452Q and MMA8453Q accelerometers
*
* (c) Copyright 2011, Freescale, Inc.  All rights reserved.
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
\***********************************************************************************************/
#ifndef _FXOS8700CQ_H_
#define _FXOS8700CQ_H_

/***********************************************************************************************\
* Public macros
\***********************************************************************************************/

// 8 Bit I2C Device Address
#define FXOS8700CQ_IIC_ADDRESS       (0x1E << 1) // Gauss
#define SXOS8700CQ_IIC_ADDRESS       (0x1E << 1)
#define MXOS8700CQ_IIC_ADDRESS       (0x4C << 1)
#define GAUSS_SI2P0_IIC_ADDRESS      (0x4E << 1)

#define FXOS8700CQ_IIC_ADDRESS_A1    0x3A // 7 Bit value = 0x1D

/***********************************************************************************************
**
**  FXOS8700CQQ Sensor Internal Registers
*/
enum
{
  FXOS8700CQ_STATUS,                 // 0x00 
  FXOS8700CQ_OUT_X_MSB,              // 0x01
  FXOS8700CQ_OUT_X_LSB,              // 0x02
  FXOS8700CQ_OUT_Y_MSB,              // 0x03
  FXOS8700CQ_OUT_Y_LSB,              // 0x04
  FXOS8700CQ_OUT_Z_MSB,              // 0x05
  FXOS8700CQ_OUT_Z_LSB,              // 0x06
  FXOS8700CQ_RSVD_0,                 // 0x07  
  FXOS8700CQ_RSVD_1,                 // 0x08  
  FXOS8700CQ_F_SETUP,                // 0x09 
  FXOS8700CQ_TRIG_CFG,               // 0x0A 
  FXOS8700CQ_SYSMOD,                 // 0x0B
  FXOS8700CQ_INT_SOURCE,             // 0x0C
  FXOS8700CQ_WHO_AM_I,               // 0x0D
  FXOS8700CQ_XYZ_DATA_CFG,           // 0x0E
  FXOS8700CQ_HP_FILTER_CUTOFF,       // 0x0F
  FXOS8700CQ_PL_STATUS,              // 0x10
  FXOS8700CQ_PL_CFG,                 // 0x11
  FXOS8700CQ_PL_COUNT,               // 0x12
  FXOS8700CQ_PL_BF_ZCOMP,            // 0x13
  FXOS8700CQ_PL_P_L_THS_REG,         // 0x14
  FXOS8700CQ_FF_MT_CFG,              // 0x15
  FXOS8700CQ_FF_MT_SRC,              // 0x16
  FXOS8700CQ_FF_MT_THS,              // 0x17
  FXOS8700CQ_FF_MT_COUNT,            // 0x18
  FXOS8700CQ_RSVD_2,                 // 0x19  
  FXOS8700CQ_RSVD_3,                 // 0x1A  
  FXOS8700CQ_RSVD_4,                 // 0x1B  
  FXOS8700CQ_RSVD_5,                 // 0x1C  
  FXOS8700CQ_TRANSIENT_CFG,          // 0x1D
  FXOS8700CQ_TRANSIENT_SRC,          // 0x1E
  FXOS8700CQ_TRANSIENT_THS,          // 0x1F
  FXOS8700CQ_TRANSIENT_COUNT,        // 0x20
  FXOS8700CQ_PULSE_CFG,              // 0x21
  FXOS8700CQ_PULSE_SRC,              // 0x22
  FXOS8700CQ_PULSE_THSX,             // 0x23
  FXOS8700CQ_PULSE_THSY,             // 0x24
  FXOS8700CQ_PULSE_THSZ,             // 0x25
  FXOS8700CQ_PULSE_TMLT,             // 0x26
  FXOS8700CQ_PULSE_LTCY,             // 0x27
  FXOS8700CQ_PULSE_WIND,             // 0x28
  FXOS8700CQ_ASLP_COUNT,             // 0x29
  FXOS8700CQ_CTRL_REG1,              // 0x2A
  FXOS8700CQ_CTRL_REG2,              // 0x2B
  FXOS8700CQ_CTRL_REG3,              // 0x2C
  FXOS8700CQ_CTRL_REG4,              // 0x2D
  FXOS8700CQ_CTRL_REG5,              // 0x2E
  FXOS8700CQ_OFF_X,                  // 0x2F
  FXOS8700CQ_OFF_Y,                  // 0x30
  FXOS8700CQ_OFF_Z,                  // 0x31
  FXOS8700CQ_M_DR_STATUS,            // 0x32 
  FXOS8700CQ_MOUT_X_MSB,             // 0x33
  FXOS8700CQ_MOUT_X_LSB,             // 0x34
  FXOS8700CQ_MOUT_Y_MSB,             // 0x35
  FXOS8700CQ_MOUT_Y_LSB,             // 0x36
  FXOS8700CQ_MOUT_Z_MSB,             // 0x37
  FXOS8700CQ_MOUT_Z_LSB,             // 0x38
  FXOS8700CQ_CMP_X_MSB,              // 0x39
  FXOS8700CQ_CMP_X_LSB,              // 0x3A
  FXOS8700CQ_CMP_Y_MSB,              // 0x3B
  FXOS8700CQ_CMP_Y_LSB,              // 0x3C
  FXOS8700CQ_CMP_Z_MSB,              // 0x3D
  FXOS8700CQ_CMP_Z_LSB,              // 0x3E
  FXOS8700CQ_MOFF_X_MSB,             // 0x3F
  FXOS8700CQ_MOFF_X_LSB,             // 0x40
  FXOS8700CQ_MOFF_Y_MSB,             // 0x41
  FXOS8700CQ_MOFF_Y_LSB,             // 0x42
  FXOS8700CQ_MOFF_Z_MSB,             // 0x43
  FXOS8700CQ_MOFF_Z_LSB,             // 0x44
  FXOS8700CQ_MAX_X_MSB,              // 0x45
  FXOS8700CQ_MAX_X_LSB,              // 0x46
  FXOS8700CQ_MAX_Y_MSB,              // 0x47
  FXOS8700CQ_MAX_Y_LSB,              // 0x48
  FXOS8700CQ_MAX_Z_MSB,              // 0x49
  FXOS8700CQ_MAX_Z_LSB,              // 0x4A
  FXOS8700CQ_MIN_X_MSB,              // 0x4B
  FXOS8700CQ_MIN_X_LSB,              // 0x4C
  FXOS8700CQ_MIN_Y_MSB,              // 0x4D
  FXOS8700CQ_MIN_Y_LSB,              // 0x4E
  FXOS8700CQ_MIN_Z_MSB,              // 0x4F
  FXOS8700CQ_MIN_Z_LSB,              // 0x50
  FXOS8700CQ_TEMP,                   // 0x51
  FXOS8700CQ_M_THS_CFG,              // 0x52
  FXOS8700CQ_M_THS_SRC,              // 0x53
};

/*
**  STATUS Register
*/
#define STATUS_00_REG         0x00
//
#define ZYXOW_BIT             Bit._7
#define ZOW_BIT               Bit._6
#define YOW_BIT               Bit._5
#define XOW_BIT               Bit._4
#define ZYXDR_BIT             Bit._3
#define ZDR_BIT               Bit._2
#define YDR_BIT               Bit._1
#define XDR_BIT               Bit._0
//
#define ZYXOW_MASK            0x80
#define ZOW_MASK              0x40
#define YOW_MASK              0x20
#define XOW_MASK              0x10
#define ZYXDR_MASK            0x08
#define ZDR_MASK              0x04
#define YDR_MASK              0x02
#define XDR_MASK              0x01

/*
**  F_STATUS FIFO Status Register
**  MMA8451 only - when F_MODE != 0
*/
#define F_STATUS_REG          0x00
//
#define F_OVF_BIT             Bit._7
#define F_WMRK_FLAG_BIT       Bit._6
#define F_CNT5_BIT            Bit._5
#define F_CNT4_BIT            Bit._4
#define F_CNT3_BIT            Bit._3
#define F_CNT2_BIT            Bit._2
#define F_CNT1_BIT            Bit._1
#define F_CNT0_BIT            Bit._0
//
#define F_OVF_MASK            0x80
#define F_WMRK_FLAG_MASK      0x40
#define F_CNT5_MASK           0x20
#define F_CNT4_MASK           0x10
#define F_CNT3_MASK           0x08
#define F_CNT2_MASK           0x04
#define F_CNT1_MASK           0x02
#define F_CNT0_MASK           0x01
#define F_CNT_MASK            0x3F

/*
**  XYZ Data Registers
*/
#define OUT_X_MSB_REG         0x01
#define OUT_X_LSB_REG         0x02
#define OUT_Y_MSB_REG         0x03
#define OUT_Y_LSB_REG         0x04
#define OUT_Z_MSB_REG         0x05
#define OUT_Z_LSB_REG         0x06

/*
**  F_SETUP FIFO Setup Register
**  MMA8451 only
*/
#define F_SETUP_REG           0x09
//
#define F_MODE1_BIT           Bit._7
#define F_MODE0_BIT           Bit._6
#define F_WMRK5_BIT           Bit._5
#define F_WMRK4_BIT           Bit._4
#define F_WMRK3_BIT           Bit._3
#define F_WMRK2_BIT           Bit._2
#define F_WMRK1_BIT           Bit._1
#define F_WMRK0_BIT           Bit._0
//
#define F_MODE1_MASK          0x80
#define F_MODE0_MASK          0x40
#define F_WMRK5_MASK          0x20
#define F_WMRK4_MASK          0x10
#define F_WMRK3_MASK          0x08
#define F_WMRK2_MASK          0x04
#define F_WMRK1_MASK          0x02
#define F_WMRK0_MASK          0x01
#define F_MODE_MASK           0xC0
#define F_WMRK_MASK           0x3F
//
#define F_MODE_DISABLED       0x00
#define F_MODE_CIRCULAR       (F_MODE0_MASK)
#define F_MODE_FILL           (F_MODE1_MASK)
#define F_MODE_TRIGGER        (F_MODE1_MASK+F_MODE0_MASK)

/*
**  TRIG_CFG FIFO Trigger Configuration Register
**  MMA8451 only
*/
#define TRIG_CFG_REG          0x0A
//
#define TRIG_TRANS_BIT        Bit._5
#define TRIG_LNDPRT_BIT       Bit._4
#define TRIG_PULSE_BIT        Bit._3
#define TRIG_FF_MT_BIT        Bit._2
//
#define TRIG_TRANS_MASK       0x20
#define TRIG_LNDPRT_MASK      0x10
#define TRIG_PULSE_MASK       0x08
#define TRIG_FF_MT_MASK       0x04

/*
**  SYSMOD System Mode Register
*/
#define SYSMOD_REG            0x0B
//
#define FGERR_BIT             Bit._7  // MMA8451 only
#define FGT_4_BIT             Bit._6  // MMA8451 only
#define FGT_3_BIT             Bit._5  // MMA8451 only
#define FGT_2_BIT             Bit._4  // MMA8451 only
#define FGT_1_BIT             Bit._3  // MMA8451 only
#define FGT_0_BIT             Bit._2  // MMA8451 only
#define SYSMOD1_BIT           Bit._1
#define SYSMOD0_BIT           Bit._0
//
#define FGERR_MASK            0x80    // MMA8451 only
#define FGT_4_MASK            0x40    // MMA8451 only
#define FGT_3_MASK            0x20    // MMA8451 only
#define FGT_2_MASK            0x10    // MMA8451 only
#define FGT_1_MASK            0x08    // MMA8451 only
#define FGT_0_MASK            0x04    // MMA8451 only
#define FGT_MASK              0x7C    // MMA8451 only
#define SYSMOD1_MASK          0x02
#define SYSMOD0_MASK          0x01
#define SYSMOD_MASK           0x03
//
#define SYSMOD_STANDBY        0x00
#define SYSMOD_WAKE           (SYSMOD0_MASK)
#define SYSMOD_SLEEP          (SYSMOD1_MASK)

/*
**  INT_SOURCE System Interrupt Status Register
*/
#define INT_SOURCE_REG        0x0C
//
#define SRC_ASLP_BIT          Bit._7
#define SRC_FIFO_BIT          Bit._6  // MMA8451 only
#define SRC_TRANS_BIT         Bit._5
#define SRC_LNDPRT_BIT        Bit._4
#define SRC_PULSE_BIT         Bit._3
#define SRC_FF_MT_BIT         Bit._2
#define SRC_DRDY_BIT          Bit._0
//
#define SRC_ASLP_MASK         0x80
#define SRC_FIFO_MASK         0x40    // MMA8451 only
#define SRC_TRANS_MASK        0x20
#define SRC_LNDPRT_MASK       0x10
#define SRC_PULSE_MASK        0x08
#define SRC_FF_MT_MASK        0x04
#define SRC_DRDY_MASK         0x01

/*
**  WHO_AM_I Device ID Register
*/
#define WHO_AM_I_REG          0x0D
// 
#define FXOS8700CQ            0xC7
#define SXOS8700CQ            0xC8
#define MXOS8700CQ            0xC4
#define GAUSS_SI2P0           0xC4


/*
**  XYZ_DATA_CFG Sensor Data Configuration Register
*/
#define XYZ_DATA_CFG_REG      0x0E
//
#define HPF_OUT_BIT           Bit._4  // MMA8451 and MMA8452 only
#define FS1_BIT               Bit._1
#define FS0_BIT               Bit._0
//
#define HPF_OUT_MASK          0x10    // MMA8451 and MMA8452 only
#define FS1_MASK              0x02
#define FS0_MASK              0x01
#define FS_MASK               0x03
//
#define FULL_SCALE_2G         0x00
#define FULL_SCALE_4G         (FS0_MASK)
#define FULL_SCALE_8G         (FS1_MASK)

/*
**  HP_FILTER_CUTOFF High Pass Filter Register
*/
#define HP_FILTER_CUTOFF_REG  0x0F
//
#define PULSE_HPF_BYP_BIT     Bit._5
#define PULSE_LPF_EN_BIT      Bit._4
#define SEL1_BIT              Bit._1
#define SEL0_BIT              Bit._0
//
#define PULSE_HPF_BYP_MASK    0x20
#define PULSE_LPF_EN_MASK     0x10
#define SEL1_MASK             0x02
#define SEL0_MASK             0x01
#define SEL_MASK              0x03

/*
**  PL_STATUS Portrait/Landscape Status Register
*/
#define PL_STATUS_REG         0x10
//
#define NEWLP_BIT             Bit._7
#define LO_BIT                Bit._6
#define LAPO1_BIT             Bit._2
#define LAPO0_BIT             Bit._1
#define BAFRO_BIT             Bit._0
//
#define NEWLP_MASK            0x80
#define LO_MASK               0x40
#define LAPO1_MASK            0x04
#define LAPO0_MASK            0x02
#define BAFRO_MASK            0x01
#define LAPO_MASK             0x06

/*
**  PL_CFG Portrait/Landscape Configuration Register
*/
#define PL_CFG_REG            0x11
//
#define DBCNTM_BIT            Bit._7
#define PL_EN_BIT             Bit._6
//
#define DBCNTM_MASK           0x80
#define PL_EN_MASK            0x40

/*
**  PL_COUNT Portrait/Landscape Debounce Register
*/
#define PL_COUNT_REG          0x12

/*
**  PL_BF_ZCOMP Back/Front and Z Compensation Register
*/
#define PL_BF_ZCOMP_REG       0x13
//
#define BKFR1_BIT             Bit._7
#define BKFR0_BIT             Bit._6
#define ZLOCK2_BIT            Bit._2
#define ZLOCK1_BIT            Bit._1
#define ZLOCK0_BIT            Bit._0
//
#define BKFR1_MASK            0x80
#define BKFR0_MASK            0x40
#define ZLOCK2_MASK           0x04
#define ZLOCK1_MASK           0x02
#define ZLOCK0_MASK           0x01
#define BKFR_MASK             0xC0
#define ZLOCK_MASK            0x07

/*
**  PL_P_L_THS Portrait to Landscape Threshold Register
*/
#define PL_P_L_THS_REG        0x14
//
#define P_L_THS4_BIT          Bit._7
#define P_L_THS3_BIT          Bit._6
#define P_L_THS2_BIT          Bit._5
#define P_L_THS1_BIT          Bit._4
#define P_L_THS0_BIT          Bit._3
#define HYS2_BIT              Bit._2
#define HYS1_BIT              Bit._1
#define HYS0_BIT              Bit._0
//
#define P_L_THS4_MASK         0x80
#define P_L_THS3_MASK         0x40
#define P_L_THS2_MASK         0x20
#define P_L_THS1_MASK         0x10
#define P_L_THS0_MASK         0x08
#define HYS2_MASK             0x04
#define HYS1_MASK             0x02
#define HYS0_MASK             0x01
#define P_L_THS_MASK          0xF8
#define HYS_MASK              0x07

/*
**  FF_MT_CFG Freefall and Motion Configuration Register
*/
#define FF_MT_CFG_REG         0x15
//
#define ELE_BIT               Bit._7
#define OAE_BIT               Bit._6
#define ZEFE_BIT              Bit._5
#define YEFE_BIT              Bit._4
#define XEFE_BIT              Bit._3
//
#define ELE_MASK              0x80
#define OAE_MASK              0x40
#define ZEFE_MASK             0x20
#define YEFE_MASK             0x10
#define XEFE_MASK             0x08

/*
**  FF_MT_SRC Freefall and Motion Source Registers
*/
#define FF_MT_SRC_REG         0x16
//
#define EA_BIT                Bit._7
#define ZHE_BIT               Bit._5
#define ZHP_BIT               Bit._4
#define YHE_BIT               Bit._3
#define YHP_BIT               Bit._2
#define XHE_BIT               Bit._1
#define XHP_BIT               Bit._0
//
#define EA_MASK               0x80
#define ZHE_MASK              0x20
#define ZHP_MASK              0x10
#define YHE_MASK              0x08
#define YHP_MASK              0x04
#define XHE_MASK              0x02
#define XHP_MASK              0x01

/*
**  FF_MT_THS Freefall and Motion Threshold Registers
**  TRANSIENT_THS Transient Threshold Register
*/
#define FT_MT_THS_REG         0x17
#define TRANSIENT_THS_REG     0x1F
//
#define DBCNTM_BIT            Bit._7
#define THS6_BIT              Bit._6
#define THS5_BIT              Bit._5
#define THS4_BIT              Bit._4
#define THS3_BIT              Bit._3
#define THS2_BIT              Bit._2
#define THS1_BIT              Bit._1
#define THS0_BIT              Bit._0
//
#define DBCNTM_MASK           0x80
#define THS6_MASK             0x40
#define THS5_MASK             0x20
#define THS4_MASK             0x10
#define THS3_MASK             0x08
#define THS2_MASK             0x04
#define TXS1_MASK             0x02
#define THS0_MASK             0x01
#define THS_MASK              0x7F

/*
**  FF_MT_COUNT Freefall Motion Count Registers
*/
#define FF_MT_COUNT_REG       0x18

/*
**  TRANSIENT_CFG Transient Configuration Register
*/
#define TRANSIENT_CFG_REG     0x1D
//
#define TELE_BIT              Bit._4
#define ZTEFE_BIT             Bit._3
#define YTEFE_BIT             Bit._2
#define XTEFE_BIT             Bit._1
#define HPF_BYP_BIT           Bit._0
//
#define TELE_MASK             0x10
#define ZTEFE_MASK            0x08
#define YTEFE_MASK            0x04
#define XTEFE_MASK            0x02
#define HPF_BYP_MASK          0x01

/*
**  TRANSIENT_SRC Transient Source Register
*/
#define TRANSIENT_SRC_REG     0x1E
//
#define TEA_BIT               Bit._6
#define ZTRANSE_BIT           Bit._5
#define Z_TRANS_POL_BIT       Bit._4
#define YTRANSE_BIT           Bit._3
#define Y_TRANS_POL_BIT       Bit._2
#define XTRANSE_BIT           Bit._1
#define X_TRANS_POL_BIT       Bit._0
//
#define TEA_MASK              0x40
#define ZTRANSE_MASK          0x20
#define Z_TRANS_POL_MASK      0x10
#define YTRANSE_MASK          0x08
#define Y_TRANS_POL_MASK      0x04
#define XTRANSE_MASK          0x02
#define X_TRANS_POL_MASK      0x01

/*
**  TRANSIENT_COUNT Transient Debounce Register
*/
#define TRANSIENT_COUNT_REG   0x20

/*
**  PULSE_CFG Pulse Configuration Register
*/
#define PULSE_CFG_REG         0x21
//
#define DPA_BIT               Bit._7
#define PELE_BIT              Bit._6
#define ZDPEFE_BIT            Bit._5
#define ZSPEFE_BIT            Bit._4
#define YDPEFE_BIT            Bit._3
#define YSPEFE_BIT            Bit._2
#define XDPEFE_BIT            Bit._1
#define XSPEFE_BIT            Bit._0
//
#define DPA_MASK              0x80
#define PELE_MASK             0x40
#define ZDPEFE_MASK           0x20
#define ZSPEFE_MASK           0x10
#define YDPEFE_MASK           0x08
#define YSPEFE_MASK           0x04
#define XDPEFE_MASK           0x02
#define XSPEFE_MASK           0x01

/*
**  PULSE_SRC Pulse Source Register
*/
#define PULSE_SRC_REG         0x22
//
#define PEA_BIT               Bit._7
#define AXZ_BIT               Bit._6
#define AXY_BIT               Bit._5
#define AXX_BIT               Bit._4
#define DPE_BIT               Bit._3
#define POLZ_BIT              Bit._2
#define POLY_BIT              Bit._1
#define POLX_BIT              Bit._0
//
#define PEA_MASK              0x80
#define AXZ_MASK              0x40
#define AXY_MASK              0x20
#define AXX_MASK              0x10
#define DPE_MASK              0x08
#define POLZ_MASK             0x04
#define POLY_MASK             0x02
#define POLX_MASK             0x01

/*
**  PULSE_THS XYZ Pulse Threshold Registers
*/
#define PULSE_THSX_REG        0x23
#define PULSE_THSY_REG        0x24
#define PULSE_THSZ_REG        0x25
//
#define PTHS_MASK             0x7F

/*
**  PULSE_TMLT Pulse Time Window Register
*/
#define PULSE_TMLT_REG        0x26

/*
**  PULSE_LTCY Pulse Latency Timer Register
*/
#define PULSE_LTCY_REG        0x27

/*
**  PULSE_WIND Second Pulse Time Window Register
*/
#define PULSE_WIND_REG        0x28

/*
**  ASLP_COUNT Auto Sleep Inactivity Timer Register
*/
#define ASLP_COUNT_REG        0x29

/*
**  CTRL_REG1 System Control 1 Register
*/
#define CTRL_REG1             0x2A
//
#define ASLP_RATE1_BIT        Bit._7
#define ASLP_RATE0_BIT        Bit._6
#define DR2_BIT               Bit._5
#define DR1_BIT               Bit._4
#define DR0_BIT               Bit._3
#define LNOISE_BIT            Bit._1
#define FREAD_BIT             Bit._1
#define ACTIVE_BIT            Bit._0
//
#define ASLP_RATE1_MASK       0x80
#define ASLP_RATE0_MASK       0x40
#define DR2_MASK              0x20
#define DR1_MASK              0x10
#define DR0_MASK              0x08
#define LNOISE_MASK           0x04
#define FREAD_MASK            0x02
#define ACTIVE_MASK           0x01
#define ASLP_RATE_MASK        0xC0
#define DR_MASK               0x38
//
#define ASLP_RATE_20MS        0x00
#define ASLP_RATE_80MS        (ASLP_RATE0_MASK)
#define ASLP_RATE_160MS       (ASLP_RATE1_MASK)
#define ASLP_RATE_640MS       (ASLP_RATE1_MASK+ASLP_RATE0_MASK)
//
#define ASLP_RATE_50HZ        (ASLP_RATE_20MS)
#define ASLP_RATE_12_5HZ      (ASLP_RATE_80MS)
#define ASLP_RATE_6_25HZ      (ASLP_RATE_160MS)
#define ASLP_RATE_1_56HZ      (ASLP_RATE_640MS)
//
#define HYB_ASLP_RATE_25HZ        (ASLP_RATE_20MS)
#define HYB_ASLP_RATE_6_25HZ      (ASLP_RATE_80MS)
#define HYB_ASLP_RATE_1_56HZ      (ASLP_RATE_160MS)
#define HYB_ASLP_RATE_0_8HZ       (ASLP_RATE_640MS)
//
#define DATA_RATE_1250US      0x00
#define DATA_RATE_2500US      (DR0_MASK)
#define DATA_RATE_5MS         (DR1_MASK)
#define DATA_RATE_10MS        (DR1_MASK+DR0_MASK)
#define DATA_RATE_20MS        (DR2_MASK)
#define DATA_RATE_80MS        (DR2_MASK+DR0_MASK)
#define DATA_RATE_160MS       (DR2_MASK+DR1_MASK)
#define DATA_RATE_640MS       (DR2_MASK+DR1_MASK+DR0_MASK)
//
#define DATA_RATE_800HZ       (DATA_RATE_1250US)
#define DATA_RATE_400HZ       (DATA_RATE_2500US)
#define DATA_RATE_200HZ       (DATA_RATE_5MS)
#define DATA_RATE_100HZ       (DATA_RATE_10MS)
#define DATA_RATE_50HZ        (DATA_RATE_20MS)
#define DATA_RATE_12_5HZ      (DATA_RATE_80MS)
#define DATA_RATE_6_25HZ      (DATA_RATE_160MS)
#define DATA_RATE_1_56HZ      (DATA_RATE_640MS)
// for hybrid (TO, Aug 2012)
#define HYB_DATA_RATE_400HZ   (DATA_RATE_1250US)
#define HYB_DATA_RATE_200HZ   (DATA_RATE_2500US)
#define HYB_DATA_RATE_100HZ   (DATA_RATE_5MS)
#define HYB_DATA_RATE_50HZ    (DATA_RATE_10MS)
#define HYB_DATA_RATE_25HZ    (DATA_RATE_20MS)
#define HYB_DATA_RATE_6_25HZ  (DATA_RATE_80MS)
#define HYB_DATA_RATE_3_15HZ  (DATA_RATE_160MS)
#define HYB_DATA_RATE_0_8HZ   (DATA_RATE_640MS) 

//
#define ACTIVE                (ACTIVE_MASK)
#define STANDBY               0x00

/*
**  CTRL_REG2 System Control 2 Register
*/
#define CTRL_REG2             0x2B
//
#define ST_BIT                Bit._7
#define RST_BIT               Bit._6
#define SMODS1_BIT            Bit._4
#define SMODS0_BIT            Bit._3
#define SLPE_BIT              Bit._2
#define MODS1_BIT             Bit._1
#define MODS0_BIT             Bit._0
//
#define ST_MASK               0x80
#define RST_MASK              0x40
#define SMODS1_MASK           0x10
#define SMODS0_MASK           0x08
#define SLPE_MASK             0x04
#define MODS1_MASK            0x02
#define MODS0_MASK            0x01
#define SMODS_MASK            0x18
#define MODS_MASK             0x03
//
#define SMOD_NORMAL           0x00
#define SMOD_LOW_NOISE        (SMODS0_MASK)
#define SMOD_HIGH_RES         (SMODS1_MASK)
#define SMOD_LOW_POWER        (SMODS1_MASK+SMODS0_MASK)
//
#define MOD_NORMAL            0x00
#define MOD_LOW_NOISE         (MODS0_MASK)
#define MOD_HIGH_RES          (MODS1_MASK)
#define MOD_LOW_POWER         (MODS1_MASK+MODS0_MASK)

/*
**  CTRL_REG3 Interrupt Control Register
*/
#define CTRL_REG3             0x2C
//
#define FIFO_GATE_BIT         Bit._7  // MMA8451 only
#define WAKE_TRANS_BIT        Bit._6
#define WAKE_LNDPRT_BIT       Bit._5
#define WAKE_PULSE_BIT        Bit._4
#define WAKE_FF_MT_BIT        Bit._3
#define IPOL_BIT              Bit._1
#define PP_OD_BIT             Bit._0
//
#define FIFO_GATE_MASK        0x80    // MMA8451 only
#define WAKE_TRANS_MASK       0x40
#define WAKE_LNDPRT_MASK      0x20
#define WAKE_PULSE_MASK       0x10
#define WAKE_FF_MT_MASK       0x08
#define IPOL_MASK             0x02
#define PP_OD_MASK            0x01

/*
**  CTRL_REG4 Interrupt Enable Register
*/
#define CTRL_REG4             0x2D
//
#define INT_EN_ASLP_BIT       Bit._7
#define INT_EN_FIFO_BIT       Bit._6  // MMA8451 only
#define INT_EN_TRANS_BIT      Bit._5
#define INT_EN_LNDPRT_BIT     Bit._4
#define INT_EN_PULSE_BIT      Bit._3
#define INT_EN_FF_MT_BIT      Bit._2
#define INT_EN_DRDY_BIT       Bit._0
//
#define INT_EN_ASLP_MASK      0x80
#define INT_EN_FIFO_MASK      0x40    // MMA8451 only
#define INT_EN_TRANS_MASK     0x20
#define INT_EN_LNDPRT_MASK    0x10
#define INT_EN_PULSE_MASK     0x08
#define INT_EN_FF_MT_MASK     0x04
#define INT_EN_DRDY_MASK      0x01

/*
**  CTRL_REG5 Interrupt Configuration Register
*/
#define CTRL_REG5             0x2E
//
#define INT_CFG_ASLP_BIT      Bit._7
#define INT_CFG_FIFO_BIT      Bit._6
#define INT_CFG_TRANS_BIT     Bit._5
#define INT_CFG_LNDPRT_BIT    Bit._4
#define INT_CFG_PULSE_BIT     Bit._3
#define INT_CFG_FF_MT_BIT     Bit._2
#define INT_CFG_DRDY_BIT      Bit._0
//
#define INT_CFG_ASLP_MASK     0x80
#define INT_CFG_FIFO_MASK     0x40
#define INT_CFG_TRANS_MASK    0x20
#define INT_CFG_LNDPRT_MASK   0x10
#define INT_CFG_PULSE_MASK    0x08
#define INT_CFG_FF_MT_MASK    0x04
#define INT_CFG_DRDY_MASK     0x01

/*
**  XYZ Offset Correction Registers
*/
#define OFF_X_REG             0x2F
#define OFF_Y_REG             0x30
#define OFF_Z_REG             0x31

/*
**  M_DR_STATUS Register
*/
#define M_DR_STATUS_REG       0x32
//
#define ZYXOW_BIT             Bit._7
#define ZOW_BIT               Bit._6
#define YOW_BIT               Bit._5
#define XOW_BIT               Bit._4
#define ZYXDR_BIT             Bit._3
#define ZDR_BIT               Bit._2
#define YDR_BIT               Bit._1
#define XDR_BIT               Bit._0
//
#define ZYXOW_MASK            0x80
#define ZOW_MASK              0x40
#define YOW_MASK              0x20
#define XOW_MASK              0x10
#define ZYXDR_MASK            0x08
#define ZDR_MASK              0x04
#define YDR_MASK              0x02
#define XDR_MASK              0x01

/*
**  MAG XYZ Data Registers
*/
#define M_OUT_X_MSB_REG       0x33
#define M_OUT_X_LSB_REG       0x34
#define M_OUT_Y_MSB_REG       0x35
#define M_OUT_Y_LSB_REG       0x36
#define M_OUT_Z_MSB_REG       0x37
#define M_OUT_Z_LSB_REG       0x38

/*
**  MAG CMP Data Registers
*/
#define CMP_X_MSB_REG         0x39
#define CMP_X_LSB_REG         0x3A
#define CMP_Y_MSB_REG         0x3B
#define CMP_Y_LSB_REG         0x3C
#define CMP_Z_MSB_REG         0x3D
#define CMP_Z_LSB_REG         0x3E

/*
**  MAG XYZ Offset Correction Registers
*/
#define M_OFF_X_MSB_REG       0x3F
#define M_OFF_X_LSB_REG       0x40
#define M_OFF_Y_MSB_REG       0x41
#define M_OFF_Y_LSB_REG       0x42
#define M_OFF_Z_MSB_REG       0x43
#define M_OFF_Z_LSB_REG       0x44

/*
**  MAG MAX XYZ Registers
*/
#define MAX_X_MSB_REG         0x45
#define MAX_X_LSB_REG         0x46
#define MAX_Y_MSB_REG         0x47
#define MAX_Y_LSB_REG         0x48
#define MAX_Z_MSB_REG         0x49
#define MAX_Z_LSB_REG         0x4A

/*
**  MAG MIN XYZ Registers
*/
#define MIN_X_MSB_REG         0x4B
#define MIN_X_LSB_REG         0x4C
#define MIN_Y_MSB_REG         0x4D
#define MIN_Y_LSB_REG         0x4E
#define MIN_Z_MSB_REG         0x4F
#define MIN_Z_LSB_REG         0x50

/*
**  TEMP Registers
*/
#define TEMP_REG              0x51

/*
**  M_THS CONFIG Registers
*/
#define M_THS_CFG_REG         0x52

/*
**  M_THS SRC Registers
*/
#define M_THS_SRC_REG         0x53

/*
**  MAG THRESHOLD XYZ Registers
*/
#define M_THS_X_MSB_REG       0x54
#define M_THS_X_LSB_REG       0x55
#define M_THS_Y_MSB_REG       0x56
#define M_THS_Y_LSB_REG       0x57
#define M_THS_Z_MSB_REG       0x58
#define M_THS_Z_LSB_REG       0x59

/*
**  M_THS COUNT Registers
*/
#define M_THS_COUNT           0x5A

/*
**  MAG CTRL_REG1 System Control 1 Register
*/
#define M_CTRL_REG1           0x5B
//
#define M_HMS_0_BIT           Bit._7
#define M_HMS_1_BIT           Bit._6
#define M_OS_2_BIT            Bit._5
#define M_OS_1_BIT            Bit._4
#define M_OS_0_BIT            Bit._3
#define M_OST_BIT             Bit._2
#define M_RST_BIT             Bit._1
#define M_ACAL_BIT            Bit._0
//
#define M_ACAL_MASK           0x80
#define M_RST_MASK            0x40
#define M_OST_MASK            0x20
#define M_OSR2_MASK           0x10
#define M_OSR1_MASK           0x08
#define M_OSR0_MASK           0x04
#define M_HMS1_MASK           0x02
#define M_HMS0_MASK           0x01
#define M_OSR_MASK            0x1C
#define M_HMS_MASK            0x03

//OSR Selections
#define M_OSR_1_56_HZ         0x00
#define M_OSR_6_25_HZ         M_OSR0_MASK
#define M_OSR_12_5_HZ         M_OSR1_MASK
#define M_OSR_50_HZ           M_OSR1_MASK+M_OSR0_MASK
#define M_OSR_100_HZ          M_OSR2_MASK
#define M_OSR_200_HZ          M_OSR2_MASK+M_OSR0_MASK
#define M_OSR_400_HZ          M_OSR2_MASK+M_OSR1_MASK
#define M_OSR_800_HZ          M_OSR2_MASK+M_OSR1_MASK+M_OSR0_MASK

//Hybrid Mode Selection
#define ACCEL_ACTIVE          0x00
#define MAG_ACTIVE            M_HMS0_MASK
#define HYBRID_ACTIVE         (M_HMS1_MASK | M_HMS0_MASK)


/*
**  MAG CTRL_REG2 System Control 2 Register
*/
#define M_CTRL_REG2           0x5C
//
#define M_HYB_AUTOINC_BIT     Bit._5
#define M_MAXMIN_DIS_BIT      Bit._4
#define M_MAXMIN_DIS_THS_BIT  Bit._3
#define M_MAXMIN_RST_BIT      Bit._2
#define M_RST_CNT1_BIT        Bit._1
#define M_RST_CNT0_BIT        Bit._0

#define M_HYB_AUTOINC_MASK    0x20
#define M_MAXMIN_DIS_MASK     0x10
#define M_MAXMIN_DIS_THS_MASK 0x08
#define M_MAXMIN_RST_MASK     0x04
#define M_RST_CNT1_MASK       0x02
#define M_RST_CNT0_MASK       0x01

//Mag Auto-Reset De-Gauss Frequency
#define RST_ODR_CYCLE         0x00
#define RST_16_ODR_CYCLE      M_RST_CNT0_MASK
#define RST_512_ODR_CYCLE     M_RST_CNT1_MASK
#define RST_DISABLED          M_RST_CNT1_MASK+M_RST_CNT0_MASK

/*
**  MAG CTRL_REG3 System Control 3 Register
*/
#define M_CTRL_REG3           0x5D
//

#define M_RAW_BIT             Bit._7
#define M_ASLP_OS_2_BIT       Bit._6
#define M_ASLP_OS_1_BIT       Bit._5
#define M_ASLP_OS_0_BIT       Bit._4
#define M_THS_XYZ_BIT         Bit._3
#define M_ST_Z_BIT            Bit._2
#define M_ST_XY1_BIT          Bit._1
#define M_ST_XY0_BIT          Bit._0

#define M_RAW_MASK            0x80
#define M_ASLP_OS_2_MASK      0x40
#define M_ASLP_OS_1_MASK      0x20
#define M_ASLP_OS_0_MASK      0x10
#define M_THS_XYZ_MASK        0x08
#define M_ST_Z_MASK           0x04
#define M_ST_XY1_MASK         0x02
#define M_ST_XY0_MASK         0x01
#define M_ASLP_OSR_MASK       0x70
#define M_ST_XY_MASK          0x03

//OSR Selections
#define M_ASLP_OSR_1_56_HZ    0x00
#define M_ASLP_OSR_6_25_HZ    M_ASLP_OS_0_MASK
#define M_ASLP_OSR_12_5_HZ    M_ASLP_OS_1_MASK
#define M_ASLP_OSR_50_HZ      M_ASLP_OS_1_MASK+M_ASLP_OS_0_MASK
#define M_ASLP_OSR_100_HZ     M_ASLP_OS_2_MASK
#define M_ASLP_OSR_200_HZ     M_ASLP_OS_2_MASK+M_ASLP_OS_0_MASK
#define M_ASLP_OSR_400_HZ     M_ASLP_OS_2_MASK+M_ASLP_OS_1_MASK
#define M_ASLP_OSR_800_HZ     M_ASLP_OS_2_MASK+M_ASLP_OS_1_MASK+M_ASLP_OS_0_MASK

/*
**  MAG INT SOURCE Register
*/
#define M_INT_SOURCE          0x5E
//

#define SRC_M_DRDY_BIT        Bit._2
#define SRC_M_VECM_BIT        Bit._1
#define SRC_M_THS_BIT         Bit._0

#define SRC_M_DRDY_MASK       0x04
#define SRC_M_VECM_MASK       0x02
#define SRC_M_THS_MASK        0x01

/*
**  ACCEL VECTOR CONFIG Register
*/
#define A_VECM_CFG            0x5F
//

#define A_VECM_INIT_CFG_BIT   Bit._6
#define A_VECM_INIT_EN_BIT    Bit._5
#define A_VECM_WAKE_EN_BIT    Bit._4
#define A_VECM_EN_BIT         Bit._3
#define A_VECM_UPDM_BIT       Bit._2
#define A_VECM_INITM_BIT      Bit._1
#define A_VECM_ELE_BIT        Bit._0

#define A_VECM_INIT_CFG_MASK  0x40
#define A_VECM_INIT_EN_MASK   0x20
#define A_VECM_WAKE_EN_MASK   0x10
#define A_VECM_EN_MASK        0x08
#define A_VECM_UPDM_MASK      0x04
#define A_VECM_INITM_MASK     0x02
#define A_VECM_ELE_MASK       0x01

/*
**  ACCEL VECTOR THS MSB AND LSB Register
*/
#define A_VECM_THS_MSB        0x60

#define A_VECM_DBCNTM_BIT     Bit._7
#define A_VECM_DBCNTM_MASK    0x80

#define A_VECM_THS_LSB        0x61
/*
**  ACCEL VECTOR CNT Register
*/
#define A_VECM_CNT            0x62

/*
**  ACCEL INITIAL XYZ VECTORS Register
*/
#define A_VECM_INITX_MSB      0x63
#define A_VECM_INITX_LSB      0x64
#define A_VECM_INITY_MSB      0x65
#define A_VECM_INITY_LSB      0x66
#define A_VECM_INITZ_MSB      0x67
#define A_VECM_INITZ_LSB      0x68

/*
**  MAG VECTOR CONFIG Register
*/
#define M_VECM_CFG            0x69
//

#define M_VECM_INIT_CFG_BIT   Bit._6
#define M_VECM_INIT_EN_BIT    Bit._5
#define M_VECM_WAKE_EN_BIT    Bit._4
#define M_VECM_EN_BIT         Bit._3
#define M_VECM_UPDM_BIT       Bit._2
#define M_VECM_INITM_BIT      Bit._1
#define M_VECM_ELE_BIT        Bit._0

#define M_VECM_INIT_CFG_MASK  0x40
#define M_VECM_INIT_EN_MASK   0x20
#define M_VECM_WAKE_EN_MASK   0x10
#define M_VECM_EN_MASK        0x08
#define M_VECM_UPDM_MASK      0x04
#define M_VECM_INITM_MASK     0x02
#define M_VECM_ELE_MASK       0x01

/*
**  MAG VECTOR THS MSB AND LSB Register
*/
#define M_VECM_THS_MSB        0x6A

#define M_VECM_DBCNTM_BIT     Bit._7
#define M_VECM_DBCNTM_MASK    0x80

#define M_VECM_THS_LSB        0x6B
/*
**  MAG VECTOR CNT Register
*/
#define M_VECM_CNT            0x6C

/*
**  MAG INITIAL XYZ VECTORS Register
*/
#define M_VECM_INITX_MSB      0x6D
#define M_VECM_INITX_LSB      0x6E
#define M_VECM_INITY_MSB      0x6F
#define M_VECM_INITY_LSB      0x70
#define M_VECM_INITZ_MSB      0x71
#define M_VECM_INITZ_LSB      0x72

/*
**  ACCEL FFMT THS X MSB AND LSB Register
*/
#define A_FFMT_THS_X_MSB       0x73

#define A_FFMT_THS_X_EN_BIT  Bit._7
#define A_FFMT_THS_XYZ_EN_MASK 0x80

#define A_FFMT_THS_X_LSB       0x74

#define A_FFMT_THS_X_LSB_MASK  0xFC

/*
**  ACCEL FFMT THS Y MSB AND LSB Register
*/
#define A_FFMT_THS_Y_MSB       0x75

#define A_FFMT_THS_Y_EN_BIT  Bit._7
#define A_FFMT_THS_Y_EN_MASK 0x80

#define A_FFMT_THS_Y_LSB       0x76

#define A_FFMT_THS_Y_LSB_MASK  0xFC

/*
**  ACCEL FFMT THS Z MSB AND LSB Register
*/
#define A_FFMT_THS_Z_MSB       0x77

#define A_FFMT_THS_Z_EN_BIT  Bit._7
#define A_FFMT_THS_Z_EN_MASK 0x80

#define A_FFMT_THS_Z_LSB       0x78

#define A_FFMT_THS_Z_LSB_MASK  0xFC

/*
**  ACCEL TRANSIENT INIT Register
*/
#define A_TRAN_INIT_XYZ_MSB   0x79
#define A_TRAN_INIT_X_LSB     0x7A
#define A_TRAN_INIT_Y_LSB     0x7B
#define A_TRAN_INIT_Z_LSB     0x7C

/***********************************************************************************************\
* Public type definitions
\***********************************************************************************************/

/***********************************************************************************************\
* Public memory declarations
\***********************************************************************************************/

/***********************************************************************************************\
* Public prototypes
\***********************************************************************************************/

void FXOS8700CQ_Init(void);
byte FXOS8700CQ_Standby(void);
void FXOS8700CQ_Active(void);


#endif  /* _FXOS8700CQ_H_ */
